<?php

namespace VM\AdminBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Response;
use VM\FinancialStatementsBundle\Services\Reports\Svg\SvgChart;

class DefaultController extends Controller
{
    public function indexAction()
    {
        if(!$this->get('security.context')->isGranted('ROLE_TEACHER'))
        {
            return $this->redirect($this->generateUrl('vm_front_homepage'));
        }
        return $this->render('VMAdminBundle:Default:index.html.twig');
    }


    public function chartAction()
    {
        if(!$this->get('security.context')->isGranted('ROLE_TEACHER'))
        {
            return $this->redirect($this->generateUrl('vm_front_homepage'));
        }

        $data = array();

        for($i = 1; $i <= 9; $i++)
        {
            $val = rand(-10000000, 10000000);
            $data[] = array(
                'label' => 'Tura ' . $i,
                'value' => $val
            );
        }
        $Chart = new SvgChart();
        $image = $Chart->create($data);
        $Response = new Response($image);
        return $Response;
    }

    /**
     * @return Response
     */
    public function getFileAction()
    {
        $Response = new Response();

        $mime = 'application/zip';

        if($this->getRequest()->getSession()->has('last_generate_file_path') && is_file($this->getRequest()->getSession()->get('last_generate_file_path')))
        {
            $finfo = finfo_open(FILEINFO_MIME_TYPE);
            $mime = finfo_file($finfo, $this->getRequest()->getSession()->get('last_generate_file_path'));
            $Response->headers->set('Content-Type', $mime);
            $Response->headers->set('Cache-Control', 'must-revalidate; post-check=0; pre-check=0');
            $Response->headers->set('Pragma', 'public');
            $Response->headers->set('Content-Disposition', 'attachment; filename="' . $this->getRequest()->getSession()->get('last_generate_file_name').'"');
            $Response->setContent(file_get_contents($this->getRequest()->getSession()->get('last_generate_file_path')));
        }

        return $Response;
    }

    /**
     * @return Response
     */
    public function sparqlAction()
    {
        $Response = new Response('sparql');

        $config = array(
            /* db */
            'db_host' => $this->container->getParameter('sparql_host'),
            'db_name' => $this->container->getParameter('sparql_database'),
            'db_user' => $this->container->getParameter('sparql_user'),
            'db_pwd' => $this->container->getParameter('sparql_password'),
            'store_name' => $this->container->getParameter('sparql_prefix'),
            'bnode_prefix' => $this->container->getParameter('sparql_bn'),
            'sem_html_formats' => $this->container->getParameter('sparql_html'),

            /* endpoint */
            'endpoint_features' => array(
                'select', 'construct', 'ask', 'describe',
                'load', 'insert', 'delete',
                'dump'
            ),
            'endpoint_timeout' => 60,
            'endpoint_read_key' => $this->container->getParameter('sparql_key2'), /* optional */
            'endpoint_write_key' => $this->container->getParameter('sparql_key'), /* optional, but without one, everyone can write! */
            'endpoint_max_limit' => 1000, /* optional */
        );

        /* instantiation */
        $ep = \ARC2::getStoreEndpoint($config);

        if (!$ep->isSetUp()) {
            $ep->setUp(); /* create MySQL tables */
        }

        /* request handling */
        $content = $ep->go();

//        $ep->handleRequest();
//        $ep->sendHeaders();
//        $content = $ep->getResult();

        $Response->setContent($content);



        return $Response;
    }
}
